#include<iostream.h>
#include<fstream.h>
#include<string.h>
#include<stdlib.h>
#include<conio.h>
#include<iomanip.h>
#include<windows.h>

//------------------------ E X C E P T I O N  C L A S S ----------------------------------
//class for throwing exception when an out of bound memory access is made

class Array_Index_Out_Of_Bound_Exception
{
	private:
		char *message;

	public:

		//DEAFULT CONSTRUCTOR THAT SETS THE VALUE IN THE MESSAGE VARIABLE
		Array_Index_Out_Of_Bound_Exception(): message ("Array Index Out of Bound")
		{	
			cout<<what();

			exit(1);
		}

		//ARGUMENT CONSTRUCTOR THAT SETS THE VALUE IN THE MESSAGE VARIABLE
		Array_Index_Out_Of_Bound_Exception(char * new_message)
		{	
			message=new char[strlen(new_message)];
			strcpy(message,new_message);

			cout<<what();

			exit(1);
		}

		//DESTRUCTOR
		~Array_Index_Out_Of_Bound_Exception()
		{ }

		//MEMBER FUNCTION THAT RETURNS THE VALUE OF THE MESSAGE
		const char* what() const 
		{ 
			return message; 
		}
};

//--------------------------- S W A P P I N G ----------------------------------

template <class DATATYPE>

void Swap(DATATYPE &A , DATATYPE &B)
{
	DATATYPE Temp;

	Temp=A;
	A=B;
	B=Temp;
}

//--------------------------- S E L E C T I O N  S O R T ----------------------------------

template <class DATATYPE>

void Selection_Sort(DATATYPE array[],int L, int R)
{
	for (int i =L ; i <=R ; i++)
	{
		int min=i;

		for (int j=i+1 ; j<=R ; j++)
		{
			if (array[j]<array[min])
				min=j;				
		}
		Swap(array[min],array[i]);		
	}	
}

//--------------------------- I N S E R T I O N  S O R T ----------------------------------

template <class DATATYPE>

void Insertion_Sort(DATATYPE array[],int L, int R)
{
	for (int i=L ; i<=R ; i++)
	{
		DATATYPE temp=array[i];

		for (int j=i ; j>L ; j--)
		{
			if (temp<array[j-1])
			{
				array[j]=array[j-1];
			}
			else 
				break;
		}
		array[j]=temp;
	}			
}

//--------------------------- B U B B L E  S O R T ----------------------------------
//------------------------ ( W i t h  B o o l e a n ) -------------------------------

template <class DATATYPE>

void Bubble_Sort_With_Boolean(DATATYPE array[],int L, int R)
{
	bool check=1;

	for (int i=R-1 ; i>=L ; i--)
	{
		check=1;

		for (int j=L ; j<=i ; j++)
		{			
			if (array[j]>array[j+1])
			{
				Swap(array[j],array[j+1]);				
				check=0;
			}
		}

		if (check)
			break;
	}		
}

//--------------------------- B U B B L E  S O R T ----------------------------------
//-------------------- ( W i t h o u t  B o o l e a n ) -------------------------------

template <class DATATYPE>

void Bubble_Sort_Without_Boolean(DATATYPE array[],int L, int R)
{
	for (int i=R-1 ; i>=L ; i--)
	{
		for (int j=L ; j<=i ; j++)
		{			
			if (array[j]>array[j+1])
			{
				Swap(array[j],array[j+1]);				
			}
		}		
	}		
}

//-------------------------  S H E L L   S O R T I N G  ----------------------------------

template <class DATATYPE>

void Shell_Sort(DATATYPE array[],int L, int R)
{
	int index=0,h=0;
	DATATYPE temp;

	for (h=1 ; h<=(R-1)/9 ; h=(h*3)+1);
	
	for (; h>0 ; h/=3)
	{
		for (int i=h ; i<=R ; i++)
		{
			temp=array[i];
			index=i;

			while ( index>=h && array[index-h]>temp)
			{
				array[index]=array[index-h];
				index-=h;
			}
			array[index]=temp;
		}
	}	
}

//-------------------------  Q U I C K   S O R T I N G  ----------------------------------

template <class DATATYPE>

int Partition(DATATYPE a[], int L, int R)
{	
	int i=0 , j=0;
	i=L ; j=R-1;
	DATATYPE temp=a[R];

	do
	{
		while( a[i]<temp) ++i;
		while(temp<a[j]) --j;
	
		if (j==L) 
			break;

		if (i>=j)
			break;

		Swap(a[i],a[j]);
	}
	while(++i<=--j);
			
	Swap(a[i],a[R]);

	return i;
}

template <class DATATYPE>

void Quick_Sort(DATATYPE a[], int L , int R)
{
	if (R<=L)
		return;
	
	int i=Partition(a,L,R);

	if (i-L > R-i)
	{
		Quick_Sort(a,L,i-1);
		Quick_Sort(a,i+1,R);		
	}
	else
	{
		Quick_Sort(a,i+1,R);		
		Quick_Sort(a,L,i-1);	
	}

}

template <class DATATYPE>

//--------------------------- S A F E  A R R A Y ----------------------------------

class Safe_Array
{
	friend istream &operator>>(istream &, Safe_Array<DATATYPE> &);
	friend ostream &operator<< (ostream &, Safe_Array<DATATYPE> &);

	private:
			DATATYPE *array;
			int size;

	public:

		Safe_Array() : array(NULL) , size(0)
		{	}

		Safe_Array(int new_size) : size(new_size)
		{	
			array=new DATATYPE[new_size];
		}

		/*~Safe_Array()
		{
			if (array!=NULL)
				delete [] array;						
		}*/

		Safe_Array(const Safe_Array<DATATYPE> &arr)	
		{
			if (arr.size<=0)
				throw Array_Index_Out_Of_Bound_Exception("Index Number is below Zero !");				
				
			if (array!=NULL)
				delete array;

			size=arr.size;

			array=new DATATYPE[size];

			for (int i=0 ; i<size ; i++)
			{
				array[i]=arr.array[i];
			}			
		}

		Safe_Array<DATATYPE>& operator=(const Safe_Array<DATATYPE> &arr)	
		{
			if (array!=NULL)
				delete [] array;						

			(*this).array=new DATATYPE[arr.size];

			for (int i=0 ; i<size ; i++)
			{
				(*this).array[i]=arr.array[i];
			}			

			return (*this);
		}

		DATATYPE& operator[](int num)
		{
			if ((num<0)||(num>=size))
				throw Array_Index_Out_Of_Bound_Exception();				

			else
				return array[num];
		}

		void Allocate(long num)
		{
			if (array!=NULL)
				delete [] array;		
			
			size=num;

			(*this).array=new DATATYPE[size];
		}
		
		void SelectionSort()
		{
			Selection_Sort(array,1,size);
		}

		void InsertionSort()
		{
			Insertion_Sort(array,1,size);
		}

		void BubbleSortWithBoolean()
		{
			Bubble_Sort_With_Boolean(array,1,size);
		}

		void BubbleSortWithoutBoolean()
		{
			Bubble_Sort_Without_Boolean(array,1,size);
		}

		void ShellSort()
		{
			Shell_Sort(array,1,size);
		}

		void QuickSort()
		{
			Quick_Sort(array,1,size);
		}
};

template <class DATATYPE>

istream &operator>>(istream &input, Safe_Array<DATATYPE> &arr)
{
	for (int i=1 ; i<=arr.size ; i++)
	{
		input>>arr.array[i];
	}
	return input;
}

template <class DATATYPE>

ostream &operator<< (ostream &output, Safe_Array<DATATYPE> &arr)
{
	for (int i=1 ; i<=arr.size ; i++)
	{
		output<<arr.array[i]<<endl;
	}	
	
	return output;
}

template <class DATATYPE>

Sorting_on_Data(Safe_Array<DATATYPE> &array,int size , char* type ,ifstream &inFile1,ifstream &inFile2,ofstream &outFile)
{
	outFile<<"\t-------------------------------------------------------------------------"<<endl;
	outFile<<"\t                    S O R T I N G  A N A L Y S I S "<<endl;
	outFile<<"\t-------------------------------------------------------------------------"<<endl;
	outFile<<setw(35)<<" ( "<<size<<setw(10)<<type<< " ) "<<endl;
	outFile<<"\t-------------------------------------------------------------------------"<<endl<<endl;
	outFile<<"\tSORTING ALGORITHM\t\tRANDOM\t\tALMOST SORTED"<<endl;
	outFile<<"\t- - - - - - - - -\t\t- - -- \t\t- - - - - - -"<<endl<<endl;
	outFile<<"\t* Selection";

	inFile1>>array;				
	long startTime = timeGetTime();
	array.SelectionSort();		
	long endTime  = timeGetTime();
	outFile<<setw(26)<<endTime-startTime;	


	inFile2>>array;				
	startTime = timeGetTime();
	array.SelectionSort();		
	endTime  = timeGetTime();
	outFile<<setw(19)<<endTime-startTime<<endl<<endl;	

	outFile<<"\t* Insertion";

	inFile1.seekg(0);      
	inFile1>>array;	
	startTime = timeGetTime();
	array.InsertionSort();		
	endTime  = timeGetTime();
	outFile<<setw(26)<<endTime-startTime;	

	inFile2.seekg(0);      
	inFile2>>array;	
	startTime = timeGetTime();
	array.InsertionSort();		
	endTime  = timeGetTime();
	outFile<<setw(19)<<endTime-startTime<<endl<<endl;	

	outFile<<"\t* Bubble   ";

	inFile1.seekg(0);      
	inFile1>>array;	
	startTime = timeGetTime();
	array.BubbleSortWithoutBoolean();
	endTime  = timeGetTime();
	outFile<<setw(26)<<endTime-startTime;	

	inFile2.seekg(0);      
	inFile2>>array;	
	startTime = timeGetTime();
	array.BubbleSortWithoutBoolean();
	endTime  = timeGetTime();
	outFile<<setw(19)<<endTime-startTime<<endl<<endl;	

	outFile<<"\t* Bubble (Boolean)";

	inFile1.seekg(0);      
	inFile1>>array;	
	startTime = timeGetTime();
	array.BubbleSortWithBoolean();
	endTime  = timeGetTime();
	outFile<<setw(19)<<endTime-startTime;	

	inFile2.seekg(0);      
	inFile2>>array;	
	startTime = timeGetTime();
	array.BubbleSortWithBoolean();
	endTime  = timeGetTime();
	outFile<<setw(19)<<endTime-startTime<<endl<<endl;	

	outFile<<"\t* Shell           ";

	inFile1.seekg(0);      
	inFile1>>array;	
	startTime = timeGetTime();
	array.ShellSort();
	endTime  = timeGetTime();
	outFile<<setw(19)<<endTime-startTime;	

	inFile2.seekg(0);      
	inFile2>>array;	
	startTime = timeGetTime();
	array.ShellSort();
	endTime  = timeGetTime();
	outFile<<setw(19)<<endTime-startTime<<endl<<endl;	

	outFile<<"\t* Quick           ";

	inFile1.seekg(0);      
	inFile1>>array;	
	startTime = timeGetTime();
	array.QuickSort();
	endTime  = timeGetTime();
	outFile<<setw(19)<<endTime-startTime;	

	inFile2.seekg(0);      
	inFile2>>array;	
	startTime = timeGetTime();
	array.QuickSort();
	endTime  = timeGetTime();
	outFile<<setw(19)<<endTime-startTime<<endl<<endl;		
}

//--------------------------- D R I V E R  P R O G R A M ----------------------------------

int main(int argc , char* args[])
{
	if (argc<13)
	{
		cerr<<"INVALID NUMBER OF ARGUMENTS";
		return 1;
	}		
	
	char* out[7]={0,"5000i.txt","5000f.txt","10000i.txt","10000f.txt","25000i.txt","25000f.txt"};	
	int size[6]={5000,5000,10000,10000,25000,25000};		

	int num=0,size_count=0,File_Type_Number=0;
	char File_Type;

	for (int i=1; i<=6; i++)
	{

		//open file stream for the input and output
		ifstream inFile1(args[++num], ios::in);	
		ifstream inFile2(args[++num], ios::in);	

		//open file stream for the input and output	
		ofstream outFile(out[i], ios::out);

		//checks that the output file is open or not
		if (!outFile)
		{
			cerr<<"unable to open the output file"<<endl;
			return 2;
		}

		//checks that the input file is open or not
		if (!inFile1)
		{
			cerr<<"unable to open the input file"<<endl;
			return 3;
		}

		if ((i==1)||(i==2))
		{
			File_Type_Number=strlen(*(args+num)-5);
			File_Type=(*(args+num))[File_Type_Number];		
		}
		else
		{
			File_Type_Number=strlen(*(args+num)-6);
			File_Type=(*(args+num))[File_Type_Number];		
		}		

		if ((File_Type=='i')||(File_Type=='I'))
		{
			Safe_Array<int> array_int(size[size_count]);
			Sorting_on_Data(array_int,size[size_count],"Integer",inFile1,inFile2,outFile);
		}
		
		else if ((File_Type=='f')||(File_Type=='F'))
		{
			Safe_Array<float> array_float(size[size_count]);
			Sorting_on_Data(array_float,size[size_count],"Float",inFile1,inFile2,outFile);
		}		
		size_count++;
	}
	
	return 0;
}